--
-- raiseException.sql
--
-- This program intentionally runs a query that fails with an error.
DECLARE
  v_queryCtx  DBMS_XMLQuery.ctxType;
  v_result    CLOB;
  v_errorNum  NUMBER;
  v_errorMsg  VARCHAR2(200);
BEGIN
  -- intentionally write a query that will throw an error
  v_queryCtx := DBMS_XMLQuery.newContext('SELECT * FROM hr.employees 
                                          WHERE df = z');

  -- set the raise exception to true
  DBMS_XMLQuery.setRaiseException(v_queryCtx, true);
  DBMS_XMLQuery.setRaiseNoRowsException(v_queryCtx, true);

  -- set propagate original exception to true to get the original exception
  DBMS_XMLQuery.propagateOriginalException(v_queryCtx, true);
  v_result := DBMS_XMLQuery.getXML(v_queryCtx);

  EXCEPTION
    WHEN OTHERS THEN
      -- get the original exception
      DBMS_XMLQuery.getExceptionContent(v_queryCtx,v_errorNum, v_errorMsg);
      DBMS_OUTPUT.PUT_LINE(' Exception caught '||
                            TO_CHAR(v_errorNum)||
                                            ' '||
                                       v_errorMsg);
END; 
/
